"""add match report hash column

Revision ID: 20916ea34f25
Revises: c2b4247b094f
Create Date: 2023-01-23 15:41:22.251987

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "20916ea34f25"
down_revision = "c2b4247b094f"
branch_labels = None
depends_on = None

CONSTRAINT_NAME_MATCH_REPORT_COLUMN_REPORT_HASH_UNIQUE = (
    "hitfactorpy_constraint_match_report_report_hash_unique_20230123"
)


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "match_report",
        sa.Column(
            "report_hash",
            postgresql.UUID(as_uuid=True),
            nullable=True,
            comment="This represents an md5 hexdigest, stored as a UUID. Used to identify potential duplicate report imports.",
        ),
    )
    op.alter_column(
        "match_report",
        "id",
        existing_type=sa.INTEGER(),
        comment="Internal ID to be used as PK and FKs. Do not expose in public APIs",
        existing_nullable=False,
        autoincrement=True,
    )
    op.alter_column(
        "match_report",
        "uuid",
        existing_type=postgresql.UUID(),
        comment="ID exposed in public APIs",
        existing_nullable=False,
        existing_server_default=sa.text("gen_random_uuid()"),
    )
    op.create_unique_constraint(CONSTRAINT_NAME_MATCH_REPORT_COLUMN_REPORT_HASH_UNIQUE, "match_report", ["report_hash"])
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(CONSTRAINT_NAME_MATCH_REPORT_COLUMN_REPORT_HASH_UNIQUE, "match_report", type_="unique")
    op.alter_column(
        "match_report",
        "uuid",
        existing_type=postgresql.UUID(),
        comment=None,
        existing_comment="ID exposed in public APIs",
        existing_nullable=False,
        existing_server_default=sa.text("gen_random_uuid()"),
    )
    op.alter_column(
        "match_report",
        "id",
        existing_type=sa.INTEGER(),
        comment=None,
        existing_comment="Internal ID to be used as PK and FKs. Do not expose in public APIs",
        existing_nullable=False,
        autoincrement=True,
    )
    op.drop_column("match_report", "report_hash")
    # ### end Alembic commands ###
